<?php $__env->startSection('head'); ?>

    <!-- BEGIN PAGE LEVEL STYLES -->
    <?php echo HTML::style("assets/global/plugins/select2/css/select2.css"); ?>

    <?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css"); ?>

    <!-- END PAGE LEVEL STYLES -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo app('translator')->get("pages.expenses.indexTitle"); ?>
            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active"><?php echo app('translator')->get("pages.expenses.indexTitle"); ?></span>
            </li>

        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">

            <div class="portlet light bordered">
                <div class="portlet-body">
                    <div class="table-toolbar">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="btn-group">
                                    <a onclick="loadView('<?php echo e(route('admin.expenses.create')); ?>')" class="btn green">
                                        <?php echo e(trans('core.btnAddExpense')); ?> <?php echo e(trans('core.item')); ?> <i
                                                class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="btn-group pull-right">
                                    <span id="load_notification"></span>
                                    <input type="checkbox"
                                           onchange="ToggleEmailNotification('expense_notification');return false;"
                                           class="make-switch" name="expense_notification"
                                           <?php if($loggedAdmin->company->expense_notification==1): ?>checked
                                           <?php endif; ?> data-on-color="success" data-on-text="<?php echo e(trans('core.btnYes')); ?>"
                                           data-off-text="<?php echo e(trans('core.btnNo')); ?>" data-off-color="danger">
                                    <strong><?php echo e(trans('core.emailNotification')); ?></strong>
                                </div>
                            </div>
                        </div>
                    </div>

                    <table class="table table-striped table-bordered table-hover" id="expenses">
                        <thead>
                        <tr>
                            <th> <?php echo app('translator')->get("core.serialNo"); ?></th>
                            <th> <?php echo e(trans('core.item')); ?> </th>
                            <th> <?php echo e(trans('core.purchase_from')); ?> </th>
                            <th> <?php echo e(trans('core.date')); ?> </th>
                            <th> <?php echo e(trans('core.employee')); ?> </th>
                            <th> <?php echo e(trans('core.price')); ?> (<?php echo e($loggedAdmin->company->currency_symbol); ?>)</th>
                            <th> <?php echo e(trans('core.status')); ?> </th>
                            <th>Hidden ID</th>
                            <th> <?php echo e(trans('core.action')); ?> </th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>

                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
    <!-- END PAGE CONTENT-->

    
    <?php echo $__env->make('admin.common.delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
<?php $__env->stopSection(); ?>



<?php $__env->startSection('footerjs'); ?>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script("assets/global/plugins/select2/js/select2.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/datatables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

    

    <!-- END PAGE LEVEL PLUGINS -->

    <script>


        var table = $('#expenses').dataTable({
            processing: true,
            serverSide: true,
            <?php echo $datatabble_lang; ?>

            "ajax": "<?php echo route('admin.ajax_expenses'); ?>",
            columns: [
                {data: 's_id', name: 's_id'},
                {data: 'item_name', name: 'item_name'},
                {data: 'purchase_from', name: 'purchase_from'},
                {data: 'purchase_date', name: 'purchase_date'},
                {data: 'full_name', name: 'full_name'},
                {data: 'price', name: 'price'},
                {data: 'status', name: 'status'},
                {data: 'id', name: 'id'},
                {data: 'edit', name: 'edit'}
            ],
            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            "sPaginationType": "full_numbers",
            "columnDefs": [{  // set default column settings
                "visible": false,
                "searchable": false,
                'targets': [7]
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex) {
                var oSettings = this.fnSettings();
                $("td:first", nRow).html(oSettings._iDisplayStart + iDisplayIndex + 1);
                return nRow;
            },
            "fnInitComplete": function (oSettings, json) {
            }

        });

        // Show Delete Modal
        function del(id, name) {

            $('#deleteModal').modal('show');

            $("#deleteModal").find('#info').html('Are you sure ! You want to delete <strong>' + name + '?');

            $('#deleteModal').find("#delete").off().click(function () {

                var url = "<?php echo e(route('admin.expenses.destroy',':id')); ?>";
                url = url.replace(':id', id);

                var token = "<?php echo e(csrf_token()); ?>";

                $.easyAjax({
                    type: 'DELETE',
                    url: url,
                    data: {'_token': token},
                    container: "#deleteModal",
                    success: function (response) {
                        if (response.status === "success") {
                            $('#deleteModal').modal('hide');
                            table.fnDraw();
                        }
                    }
                });

            });
        }


        function changeStatus(id, status) {

            var url = "<?php echo e(route('admin.expense.change_status',':id')); ?>";
            url = url.replace(':id', id);

            $.easyAjax({
                type: 'POST',
                url: url,
                data: {status: status},
                container: "#deleteModal",
                success: function (response) {
                    if (response.status === "success") {
                        table.fnDraw();
                    }
                }
            });

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/expenses/index.blade.php ENDPATH**/ ?>