<?php $__env->startSection('mainarea'); ?>

    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo e($pageTitle); ?>

            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.home')); ?></a>
                <i class="fa fa-circle"></i>
            </li>

            <li>
                <span class="active"> <?php echo e(trans('core.settings')); ?></span>
            </li>
        </ul>
    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->

            <div id="load">

                

                


            </div>
            <div class="portlet light bordered">

                <div class="portlet-body form">

                    <h3>Add stripe details</h3>
                    <hr>
                    <!------------------------ BEGIN FORM---------------------->
                    <?php echo Form::model($setting, ['method' => 'PUT','class'=>'form-horizontal', 'id' => 'stripeSettings']); ?>

                    <input type="hidden" name="type" value="stripeSetting">
                    <div class="form-body">

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.stripeKey')); ?>: <span class="required">
                                        * <?php echo help_text("stripeKey"); ?> </span>(<a
                                        href="https://dashboard.stripe.com/account/apikeys" target="_blank">Generate</a>)
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="stripe_key" placeholder="Stripe Key"
                                       value="<?php echo e($setting->stripe_key); ?>">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.stripeSecret')); ?>:
                                <span class="required">
                                        * <?php echo help_text("stripeSecretKey"); ?> </span>(<a
                                        href="https://dashboard.stripe.com/account/apikeys" target="_blank">Generate</a>)
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="stripe_secret"
                                       value="<?php echo e($setting->stripe_secret); ?>" placeholder="Stripe Secret">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.stripeWebhookSecret')); ?>: <span
                                        class="required">
                                        * <?php echo help_text("stripeWebhookKey"); ?> </span>


                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control margin-bottom-15" name="stripe_webhook_secret"
                                       value="<?php echo e($setting->stripe_webhook_secret); ?>" placeholder="Stripe webhook secret">
                                <ul>
                                <li class="bmd-help"> Visit <a
                                            href="https://dashboard.stripe.com/account/webhooks"
                                            target="_blank">Generate</a> Add end point as <b> <?php echo e(route('admin.stripe.save_webhook')); ?></b> and enter the webhook key generated</li>
                                    <li> Select event <b>invoice.payment_failed</b> and <b>invoice.payment_succeeded</b> while creating webhook.</li>
                                </ul>
                            </div>

                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo app('translator')->get('core.stripeStatus'); ?> <?php echo help_text("stripeStatus"); ?> : </label>
                            <div class="btn-group col-md-6">
                                <span id="load_notification"></span>
                                <input type="checkbox"
                                       class="make-switch" name="stripe_status"
                                       <?php if($setting->stripe_status == 1): ?>checked
                                       <?php endif; ?> data-on-color="success" data-on-text="<?php echo e(trans('core.btnYes')); ?>"
                                       data-off-text="<?php echo e(trans('core.btnNo')); ?>" data-off-color="danger" value="on"/>
                            </div>
                        </div>
                        <!------------------------- END FORM ----------------------->

                        <h3>Add paypal details</h3>
                        <hr>
                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.paypalClientId')); ?>: <span class="required">
                                        * <?php echo help_text("paypalKey"); ?> </span>
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="paypal_client_id" placeholder="Paypal Key"
                                       value="<?php echo e($setting->paypal_client_id); ?>">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.paypalSecretKey')); ?>:
                                <span class="required">
                                        * <?php echo help_text("paypalSecretKey"); ?> </span>
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="paypal_secret"
                                       value="<?php echo e($setting->paypal_secret); ?>" placeholder="Paypal Secret">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.selectEnvironment')); ?>:
                                <span class="required">
                                        * <?php echo help_text("selectEnvironment"); ?> </span>
                            </label>
                            <div class="col-md-6">
                                <select class="form-control" name="paypal_mode" id="paypal_mode">
                                    <option value="sandbox" <?php if($setting->paypal_mode == 'sandbox'): ?> selected <?php endif; ?>>Sandbox</option>
                                    <option value="live" <?php if($setting->paypal_mode == 'live'): ?> selected <?php endif; ?>>Live</option>
                                </select>
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.webhookUrl')); ?>:</label>
                            <div class="col-md-6">
                                <span class="help-block"><?php echo e(route('verify-billing-ipn')); ?></span>
                                <span
                                    class="required">Add this webhook url on your paypal app settings.</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo app('translator')->get('core.paypalStatus'); ?> <?php echo help_text("paypalStatus"); ?> : </label>
                            <div class="btn-group col-md-6">
                                <span id="load_notification"></span>
                                <input type="checkbox"
                                       class="make-switch" name="paypal_status"
                                       <?php if($setting->paypal_status == 1): ?>checked
                                       <?php endif; ?> data-on-color="success" data-on-text="<?php echo e(trans('core.btnYes')); ?>"
                                       data-off-text="<?php echo e(trans('core.btnNo')); ?>" data-off-color="danger" value="on"/>
                            </div>
                        </div>

                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-9">
                                <button type="submit" onclick="stripeSetting();return false;"

                                        class="btn green"><?php echo e(trans('core.btnUpdate')); ?></button>

                            </div>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <!-- END EXAMPLE TABLE PORTLET-->

            </div>
        </div>
    </div>
    <!-- END PAGE CONTENT-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerjs'); ?>
    <?php echo HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js"); ?>

    <script>
        function stripeSetting() {
            var url = "<?php echo e(route('admin.settings.update', $setting->id)); ?>";
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '#stripeSettings',
                data: $('#stripeSettings').serialize(),
            });
        }
    </script>
    <!-- END PAGE LEVEL PLUGINS -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/settings/stripe.blade.php ENDPATH**/ ?>