<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;

class Project extends BaseModel
{

    protected static function boot()
    {
        parent::boot();


        static::addGlobalScope('company', function (Builder $builder) {
            if (admin()) {
                $builder->where('projects.company_id', admin()->company_id);
            }
          
        });


    }


    // Add your validation rules here
    public static $rules = ['name' => 'required', 'description' => 'required|min:10'];

    // Don't forget to fill this array
    protected $fillable = ['name', 'description', 'start_date', 'end_date', 'status', 'company_id'];

    public function setStartDateAttribute($value)
    {
        $this->attributes['start_date'] = date('Y-m-d', strtotime($value));
    }

    public function setEndDateAttribute($value)
    {
        $this->attributes['end_date'] = date('Y-m-d', strtotime($value));
    }

    public function scopeCompany($query, $id)
    {
        return $query->where('projects.company_id', '=', $id);
    }
}
