<?php

namespace App\Http\Controllers\Admin;

use App\Classes\Reply;
use App\Http\Controllers\AdminBaseController;

use App\Http\Requests\Admin\Project\DeleteRequest;
use App\Http\Requests\Admin\Project\EditRequest;
use App\Http\Requests\Admin\Project\StoreRequest;
use App\Http\Requests\Admin\Project\UpdateRequest;
use App\Models\Project;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\View;

use Yajra\DataTables\Facades\DataTables;

class ProjectsController extends AdminBaseController
{

    public function __construct()
    {
        parent::__construct();
        $this->pageTitle = trans('pages.projects.indexTitle');
        $this->projectsOpen = 'active';
        $this->projectsActive = 'active';
    }

    public function index(Request $request)
    {
        return View::make('admin.projects.index', $this->data);
    }

    // Datatable ajax request
    public function ajax_projects()
    {
        $result = Project::select('id', 'name', 'description', 'start_date', 'end_date', 'status', 'created_at')
            ->get();

        

        return DataTables::of($result)
            ->editColumn('status', function ($row) {
                $color = ['active' => 'success', 'inactive' => 'danger', 'closed' => 'success'];

                $status = empty($row->status)?"Active":$row->status;
                return "<span class='label label-{$color[$status]}'>" . trans("core." . $status) . "</span>";
            })->addColumn('edit', function ($row) {
                return '
                  <a  class="btn purple btn-sm margin-bottom-5"  onclick="loadView(\'' . route("admin.projects.edit", $row->id) . '\')" ><i class="fa fa-edit"></i> ' . trans("core.btnViewEditProject") . ' </a>
	              <a  href="javascript:;" onclick="del(\'' . $row->id . '\');return false;" class="btn red btn-sm margin-bottom-5">      <i class="fa fa-trash"></i> ' . trans("core.btnDelete") . ' </a>
                  <a  class="btn blue btn-sm margin-bottom-5" onclick="window.location.href=\'../admin/tasks?project_id=' . $row->id . '\';" ><i class="fa fa-list"></i> List Tasks </a>';
            })
            ->rawColumns(['status', 'edit'])
            ->make();
    }


    public function create()
    {
        $this->pageTitle = trans('pages.projects.createTitle');
        return View::make('admin.projects.create', $this->data);
    }


    public function store(StoreRequest $request)
    {

        $arrayValues = $request->toArray();
        $arrayValues['company_id'] = admin()->company_id;

        Project::create($arrayValues);

        return Reply::redirect(route('admin.projects.index'),'messages.addSuccess');
    }


    public function show($id)
    {
        $this->pageTitle = trans('pages.projects.showTitle');
        //Check employee Company
        $check = Project::company($this->company_id)->find($id);

        if ($check == null) {
            return View::make('admin.errors.noaccess', $this->data);
        }

        $project = Project::findOrFail($id);

        return View::make('admin.projects.show', compact('project'));
    }


    public function edit(EditRequest $request,$id)
    {
        $this->pageTitle = trans('pages.projects.editTitle');

        $this->project = Project::find($id);

        return View::make('admin.projects.edit', $this->data);
    }

    public function update(UpdateRequest $request, $id)
    {

        $project = Project::findOrFail($id);
        $project->update($request->toArray());
        return Reply::success('messages.updateSuccess');
    }


    public function destroy(DeleteRequest $request, $id)
    {

        Project::destroy($id);

        return Reply::success('messages.projectDeleteMessage');
    }

}
