<?php $__env->startSection('head'); ?>


    <!-- BEGIN PAGE LEVEL STYLES -->

    <?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css"); ?>

    <?php echo HTML::style("assets/global/plugins/bootstrap-summernote/summernote.css"); ?>

    <!-- END PAGE LEVEL STYLES -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo e($pageTitle); ?>

            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.home')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active">Email Templates</span>

            </li>

        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">


            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div id="load">

                

                

            </div>
            <div class="portlet light bordered">
                
                
                
                
                
                
                

                <div class="portlet-body">


                    <table class="table table-striped table-bordered table-hover" id="emails">
                        <thead>
                        <tr>

                            <th> EmailID</th>
                            <th> Subject</th>
                            <th> TEXT</th>
                            <th> Created At</th>
                            <th class="text-center"> <?php echo e(trans('core.action')); ?> </th>
                        </tr>
                        </thead>
                        <tbody>


                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
    <!-- END PAGE CONTENT-->

    

    <div id="static_edit" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"><strong><i class="fa fa-edit"></i> <?php echo e(trans('core.edit')); ?> Email
                            Template</strong></h4>
                </div>
                <div class="modal-body">
                    <div class="portlet-body form" id="edit-form-body">
                        
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>

        </div>
    </div>


    
<?php $__env->stopSection(); ?>



<?php $__env->startSection('footerjs'); ?>


    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script("assets/global/plugins/select2/js/select2.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/datatables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

    <?php echo HTML::script("assets/global/plugins/bootstrap-summernote/summernote.min.js"); ?>

    <script>
        $('#body').summernote({
            height: 300,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                // ['font', ['bold', 'italic', 'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
                ['fontname', ['fontname']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'hr']],
                ['view', ['fullscreen'/*, 'codeview' */]],   // remove codeview button
                ['help', ['help']]
            ],
        });
    </script>
    <!-- END PAGE LEVEL PLUGINS -->

    <script>


        var table = $('#emails').dataTable({
            <?php echo $datatabble_lang; ?>

            processing: true,
            serverSide: true,
            "ajax": "<?php echo e(URL::route("admin.ajax_email_templates")); ?>",
            "aaSorting": [[3, "desc"]],
            columns: [
                {data: 'email_id', name: 'email_id'},
                {data: 'subject', name: 'subject'},
                {data: 'body', name: 'body'},
                {data: 'created_at', name: 'created_at', "visible": false},
                {data: 'edit', name: 'edit', "bSortable": false}
            ],
            "iDisplayLength": 10,
            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            "sPaginationType": "full_numbers",
            "fnRowCallback": function (nRow, aData, iDisplayIndex) {

            }

        });


        function showEdit(id) {
            $('#static_edit').modal('show');
            $("body").addClass("modal-open");
            var get_url = "<?php echo e(route('admin.email_templates.edit',':id')); ?>";
            get_url = get_url.replace(':id', id);

            $("#edit-form-body").html('<div class="text-center"><?php echo HTML::image('assets/loader.gif'); ?></div>');

            $.ajax({
                type: "GET",
                url: get_url,
                data: {}
            }).done(function (response) {
                $("#edit-form-body").html(response);
                $('#body').summernote({height: 300,toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        // ['font', ['bold', 'italic', 'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
                        ['fontname', ['fontname']],
                        ['fontsize', ['fontsize']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']],
                        ['table', ['table']],
                        ['insert', ['link', 'picture', 'hr']],
                        ['view', ['fullscreen'/*, 'codeview' */]],   // remove codeview button
                        ['help', ['help']]
                    ],});
            });
        }

        function updateData(id) {
            var get_url = "<?php echo e(route('admin.email_templates.update',':id')); ?>";
            get_url = get_url.replace(':id', id);
            $("#error_edit").html('<div class="alert alert-info"><?php echo e(trans('messages.submitting')); ?>..</div>');
            $("#submitbutton_edit").prop('disabled', true);

            $.ajax({
                type: 'PUT',
                url: get_url,
                dataType: "JSON",
                data: {'subject': $('#subject').val(), 'body': $('#body').code(), 'id': id},
                success: function (response) {
                    if (response.status == "error") {
                        showToastrMessage('<?php echo e(__('messages.errorTitle')); ?>', '<?php echo e(__('messages.error')); ?>', 'error');
                        $('#error').html('');
                        var arr = response.msg;
                        var alert = '';
                        $.each(arr, function (index, value) {
                            if (value.length != 0) {
                                alert += '<p><span class="fa fa-close"></span> ' + value + '</p>';
                            }
                        });
                        $('#error_edit').html('<div class="alert alert-danger alert-dismissable"><button class="close" data-close="alert"></button> ' + alert + '</div>');
                        $("#submitbutton_edit").prop('disabled', false);
                    } else {
                        $('#static_edit').modal('hide');
                        $('#error').html('');
                        $("#submitbutton_edit").prop('disabled', false);
                        table._fnDraw();
                        showToastrMessage(response.msg, response.status, 'success');
                    }

                },
                error: function (xhr, textStatus, thrownError) {

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/email_templates/index.blade.php ENDPATH**/ ?>