<?php $__env->startSection('head'); ?>
    <!-- BEGIN PAGE LEVEL STYLES -->
    <?php echo HTML::style("assets/global/plugins/select2/css/select2.css"); ?>

    <?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css"); ?>

    <?php echo HTML::style("assets/global/plugins/datatables/plugins/responsive/responsive.bootstrap.css"); ?>

    <!-- END PAGE LEVEL STYLES -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo e(trans('pages.employees.indexTitle')); ?>

            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active"><?php echo e(trans('pages.employees.indexTitle')); ?></span>

            </li>

        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->

            <div class="portlet light bordered">

                <div class="portlet-body">
                    <div class="table-toolbar">
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="btn-group">
                                    
                                        <a href="javascript: ;" onclick="addEmployee()" class="btn green">
                                            <span class="hidden-xs"> <?php echo e(trans('core.btnAddEmployee')); ?> </span><i
                                                    class="fa fa-plus"></i>
                                        </a>
                                    
                                </div>
                            </div>
                            <div class="col-xs-6">
                               <div class="pull-right">
                                    <!-- <a href="<?php echo e(route('admin.employees.export')); ?>" class="btn red">
                                        <i class="fa fa-file-excel-o"></i> <span
                                                class="hidden-xs"><?php echo e(trans('core.export')); ?></span>
                                    </a> -->
                                    <a href="javascript:;" onclick="loadView('<?php echo e(route('admin.employees.import')); ?>')                  " class="btn blue">
<i class="fa fa-upload"></i> <span
                                   class="hidden-xs"><?php echo e(trans('core.importEmployees')); ?></span>
</a>
               </div>                           </div>
                        </div>
                    </div>

                    <table class="table table-striped table-bordered table-hover responsive hidden"
                           id="sample_employees">
                        <thead>
                        <tr>
                            <th class="text-center all">
                                <?php echo e(trans('core.employeeID')); ?>

                            </th>
                            <th class="text-center min-tablet">
                                <?php echo e(trans('core.image')); ?>

                            </th>
                            <th style="text-align: center" class="all">
                                <?php echo e(trans('core.name')); ?>

                            </th>
                            <th class="text-center min-desktop">
                                <?php echo e(trans('core.department')); ?>

                            </th>
                            <th class="text-center min-desktop">
                                <?php echo e(trans('core.designation')); ?>

                            </th>
                            <th class="text-center min-desktop">
                                <?php echo e(trans('core.atWork')); ?>

                            </th>

                            <th class="text-center min-desktop">
                                <?php echo e(trans('core.status')); ?>

                            </th>
                            <th class="never">Created AT</th>
                            <th class="text-center min-tablet">
                                <?php echo e(trans('core.actions')); ?>

                            </th>
                        </tr>
                        </thead>
                        <tbody>


                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
    <!-- END PAGE CONTENT-->

    
    <?php echo $__env->make('admin.common.delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <div id="empAddWarningModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"><?php echo e(trans('core.confirmation')); ?></h4>
                </div>
                <div class="modal-body" id="addEmployeeInfo">
                    <p>
                        <?php echo e(trans('messages.addNewEmployeeWarning')); ?>

                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal"
                            class="btn dark btn-outline"><?php echo e(trans('core.btnCancel')); ?></button>
                    <a href="javascript: ;" onclick="confirmAddEmployee()" class="btn green">
                        <span class="hidden-xs"> <?php echo e(trans('core.btnConfirm')); ?> </span>
                    </a>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerjs'); ?>


    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script("assets/global/plugins/select2/js/select2.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/datatables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/responsive/dataTables.responsive.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/responsive/responsive.bootstrap.js"); ?>


    <!-- END PAGE LEVEL PLUGINS -->
    <script>
        var total = "<?php echo e($total); ?>";
        // begin first table
        var table = $('#sample_employees').dataTable({
            <?php echo $datatabble_lang; ?>

            processing: true,
            serverSide: true,
            "ajax": "<?php echo e(route("admin.ajax_employees")); ?>",
            "autoWidth": false,
            "aaSorting": [[7, "desc"]],
            columns: [
                {data: 'employeeID', name: 'employeeID', "bSortable": true, width: "80px"},
                {data: 'profile_image', name: 'profile_image', "bSortable": false, "searchable": false},
                {data: 'full_name', name: 'full_name', "bSortable": true},
                {data: 'name', name: 'name', "bSortable": true},
                {data: 'designation', name: 'designation', "bSortable": true},
                {data: 'work', name: 'work', "bSortable": false},
                {data: 'status', name: 'status', "bSortable": true},
                {data: 'created_at', name: 'created_at', "bSortable": false, width: "150px"},
                {data: 'edit', name: 'edit', "bSortable": false},
            ],

            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            // set the initial value
            "pageLength": 5,
            "sPaginationType": "full_numbers",
            "columnDefs": [{  // set default column settings
                'orderable': false,
                'targets': [0]
            }, {  // set default column settings
                'targets': [7],
                "visible": false,
                "searchable": false
            }
            ],
            "fnInitComplete": function () {
                $(".dataTables_length").addClass("hidden-xs");
                $(this).removeClass("hidden");
            },
            "order": [
                [7, "DESC"]
            ]
        });


        function del(id, name) {

            $('#deleteModal').modal('show');

            var confirmMsg = '<?php echo trans('messages.deleteConfirm', ["name" => ":name"]); ?>';
            confirmMsg = confirmMsg.replace(":name", name);

            $("#deleteModal").find('#info').html(confirmMsg);

            $('#deleteModal').find("#delete").off().click(function () {

                var url = "<?php echo e(route('admin.employees.destroy',':id')); ?>";
                url = url.replace(':id', id);

                var token = "<?php echo e(csrf_token()); ?>";

                $.easyAjax({
                    type: 'DELETE',
                    url: url,
                    data: {'_token': token},
                    container: "#deleteModal",
                    success: function (response) {
                        if (response.status === "success") {
                            $('#deleteModal').modal('hide');
                            table.fnDraw();
                        }
                    }
                });

            });
        }


        function addEmployee() {
            var planUser = '<?php echo e(admin()->company->subscriptionPlan->end_user_count); ?>';
            if ( parseInt(planUser) >= parseInt(total) ) {
                loadView('<?php echo e(route('admin.employees.create')); ?>')

            } else {
                $('#empAddWarningModal').modal('show');
            }
        }

        function confirmAddEmployee() {
            $('#empAddWarningModal').modal('hide');
            loadView('<?php echo e(route('admin.billing.change_plan')); ?>');
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/employees/index.blade.php ENDPATH**/ ?>